#!/usr/bin/python3
# -*- coding: utf-8 -*-

import re
import subprocess
import time
from collections import defaultdict

timestamp = int(time.time())

LOG_PATH = '/app/log/app.log'

def read_macs_errors():
    macs_errors_cmd = 'timetail -n 60 -t imap {} | head -n -1 | fgrep -e "Macs error" -e "Macs notice"'.format(LOG_PATH)
    p = subprocess.Popen(macs_errors_cmd, stdout=subprocess.PIPE, shell=True)
    macs_errors = p.communicate()[0].decode('utf-8').splitlines()
    return macs_errors

def get_operation(line):
    operation_re = re.search("Macs \w+ from (\w+)", line)
    if operation_re:
        return operation_re.group(1)
    else:
        return None

def get_reason(line):
    templates = [
        'error_message="in query \w+ [\w_:]+ failed: ERROR.([\d\w \']+)',
        'error_message="in query \w+ [\w_:]+ failed: FATAL.([\d\w \']+)',
        'error_message="in query \w+ ([\d\w \']+)',
        'error_message="([\d\w \']+)'
    ]
    for template in templates:
        reason_re = re.search(template, line)
        if reason_re:
            break
    if reason_re:
        reason = reason_re.group(1)
        reason = reason.replace(" ", "_").replace(":", "").replace("'", "")
        reason = reason.strip('_')[:60]
        return reason
    else:
        return None

macs_errors = read_macs_errors()

shard_errors_count = defaultdict(int)
operation_errors_count = defaultdict(int)
error_reasons_count = defaultdict(int)

for line in macs_errors:
    shard_re = re.search("host=(\w+)\.", line)
    if shard_re:
        shard = shard_re.group(1)
        shard_errors_count[shard] += 1

    operation = get_operation(line)
    if operation:
        operation_errors_count[operation] += 1

    reason = get_reason(line)
    if reason:
        error_reasons_count[reason] += 1

for shard, errors_count in shard_errors_count.items():
    print(f"mdb.errors.by_shard.{shard} {errors_count} {timestamp}")

for operation, count in operation_errors_count.items():
    print(f"mdb.errors.by_operation.{operation} {errors_count} {timestamp}")

for reason, count in error_reasons_count.items():
    print(f"mdb.errors.by_reason.{reason} {count} {timestamp}")
