#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)

timetail -t imap -n 60 /app/log/app.log | head -n -1 | awk -v ts=$ts '
    match($0, /[A-Za-z0-9\.\-]+ with cipher [A-Za-z0-9\-]+/) {
        cipher = substr($0, RSTART, RLENGTH)
        gsub("\\.", "_", cipher)
        sub(" with cipher ", ".", cipher)
        ciphers[cipher] += 1;
    }

    END {
        for (c in ciphers) {
            print "ciphers." c, ciphers[c], ts
        }
    }'
