#!/usr/bin/python3
# -*- coding: UTF-8 -*-
import subprocess
import time
from xml.etree import ElementTree as ET
import re
import GeoIP

timestamp = int(time.time())

# Список метрик:
metrics = ['all']

# Генирируем словарь с метриками:
checks = {}
for metric in metrics:
    checks[metric] = 0
metrics = checks

# Получаем "грязный xml":
nc = 'nc -w 10 localhost 8091'
p = subprocess.Popen(nc.split(), stdout=subprocess.PIPE)
strings = p.communicate()[0].decode('utf-8').splitlines()

# Компилируем регулярки для парсинга xml:
addr = re.compile('remote_addr')

ip4 = re.compile('^::ffff:')
close_session = re.compile('</pop_session>')


gi = GeoIP.new(GeoIP.GEOIP_MEMORY_CACHE)
gi = GeoIP.open("/app/monitoring/data/GeoIP.dat",
                GeoIP.GEOIP_STANDARD)
regions = {None: 0}

# Прасим:
parse = None
for line in strings:
    if parse:
        if addr.search(line):
            ip = ET.XML(line).text
            if ip4.search(ip):
                ip = re.sub('::ffff:|:.*', '', ip)
            else:
                ip = ':'.join(ip.split(':')[0:-1])

            region = gi.country_name_by_addr(ip)
            regions[region] = regions.get(region, 0) + 1

        elif close_session.search(line):
            metrics['all'] += 1

    if line == '<sessions>':
        parse = 1
    if line == '</sessions>':
        break

# Объединяем в "Others" регионы с малым числом сессий:
all_regions = regions
regions = {'Others': 0}
for reg in all_regions:
    if all_regions[reg] < 5:
        regions['Others'] += all_regions[reg]
    else:
        regions[reg] = all_regions[reg]

for metric in metrics:
    print(f"ypop.sessions.{metric} {metrics[metric]} {timestamp}")

for reg in regions:
    region = str(reg)
    region = re.sub(' ', '_', region)
    region = re.sub(',', '', region)
    print(f"ypop.sessions.region.{region} {regions[reg]} {timestamp}")
