#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

timetail -r '^tskv\ttskv_format=pop3-log\ttimestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' -n 60 /app/log/typed.log | head -n -1 \
    | tr '[:upper:]' '[:lower:]' | awk -v ts=$(date +%s) '
    /type=command_finished/ {
        match($0, /command=([^\t]+)/, command)
        match($0, /status=([^\t]+)/, status)
        command_statuses[command[1] "." status[1]]++
        command_statuses["total." status[1]]++
    }

    END {
        for (c in command_statuses) {
            print "commands." c, command_statuses[c], ts
        }
    }'
