#pragma once

#include "backend_types.h"
#include <common/context.h>
#include <common/types.h>

#include <memory>

namespace yimap { namespace backend {

class BackendService
{
public:
    virtual ~BackendService()
    {
    }

    virtual UserJournalPtr createJournal(
        const string& uid,
        const string& clientIp,
        const string& mdb,
        const string& suid,
        const string& service = "yserver_imap") = 0;

    virtual PgServicePtr createPgService(
        const ShortSessionInfo& sessionInfo,
        bool replica,
        const std::string& service = "yserver_imap") = 0;
};

} // namespace backend
} // namespace yimap
