#pragma once

#include <user_journal/parameters/message.h>

#include <yplatform/future/future.hpp>
#include <yplatform/ptree.h>
#include <boost/shared_ptr.hpp>

#include <vector>
#include <map>

namespace macs {
class UserJournal;
struct Service;
}

namespace yimap {

struct MbodyStorageOptions
{
    enum class BackendType
    {
        Mulca,
        MDS,
        BothMulca,
        BothMDS
    };

    std::string mulcagateHost;
    std::string mulcagateAttrs;
    yplatform::time_traits::duration mulcagateTimeout;
    size_t bothMulcaPercent;
    size_t bothMDSPercent;
    size_t mdsPercent;
    bool processNonEmptyMimesByMDS;
    uint32_t processByMulcaDateYear;

    BackendType getBackendType(const std::string& sessionId, bool haveMimeParts, time_t receiveDate)
        const;
};

struct AppendOptions
{
    size_t smtpgatePercent;

    std::string smtpHost;
    uint32_t smtpPort;
    uint32_t smtpTimeout;
    size_t smtpRetryCount;
    bool smtpIpv6;

    std::string httpHost;
    uint32_t httpPort;
    size_t httpRetryCount;
    bool httpRetrySmtp;

    bool shouldUseSmtpgate(const std::string& sessionId) const;

    static AppendOptions create(const yplatform::ptree& append);
};

struct ExpungeOptions
{
    uint32_t chunkThreshold;
    uint32_t chunkSize;
    bool chunkEnable;

    static ExpungeOptions create(const yplatform::ptree& expunge);
};

struct UpdFlagsOptions
{
    uint32_t chunkThreshold;
    uint32_t chunkSize;
    bool chunkEnable;

    static UpdFlagsOptions create(const yplatform::ptree& updFlags);
};

namespace backend {

class BackendSession;
typedef std::shared_ptr<BackendSession> BackendSessionPtr;

typedef std::shared_ptr<macs::UserJournal> UserJournalPtr;
typedef boost::shared_ptr<macs::Service> PgServicePtr;

} // namespace backend
} // namespace yimap
