#pragma once

#include <backend/mbody/types.h>
#include <backend/mbody/storage/storage.h>
#include <backend/mbody/storage/string_storage.h>
#include <backend/backend_types.h>
#include <common/context.h>

namespace yimap { namespace mbody {

const std::string rootHid = "1";

//-----------------------------------------------------------------------------

class MessageAccessLibmulca
{
public:
    MessageAccessLibmulca(std::shared_ptr<Storage> storage);
    virtual ~MessageAccessLibmulca(){};

    virtual MetaAttributesPtr getHeaderStruct(const string& hid);
    virtual MetaLevelPtr getBodyStruct(const string& hid);
    virtual ConstStringPtr getHeader(const string& hid = rootHid);
    virtual ConstStringPtr getPart(const string& hid);
    virtual ConstStringPtr getBody(const string& hid);
    virtual ConstStringPtr getWhole();
    virtual size_t getRfcSize() const;

    virtual string getErrorText();

    virtual int precache()
    {
        return setMeta();
    }

private:
    MetaAttributesPtr getMessageHeaderParsed(const string& hid);

    int setMetaIfNotEmpty(const string& metaStr);
    int setMeta();
    int setMetaFromHeaderOnly();

    MessageStorageStringPtr findInlineMessage(const string& hid, int* sawoff = nullptr);
    MetaAttributesPtr getHeaderStructInlineMessage(const string& hid);
    MetaLevelPtr getBodyStructInlineMessage(const string& hid);
    ConstStringPtr getHeaderInlineMessage(const string& hid);
    ConstStringPtr getBodyInlineMessage(const string& hid);
    ConstStringPtr getInlineMessage(const string& hid);

private:
    class HeaderTextCacher
    {
    public:
        HeaderTextCacher(Storage& storage, Storage& httpStorage);

        int fetch();
        int fetchHeader();
        const string& getMeta() const;
        const string& getHeader() const;
        const string& getText() const;
        size_t getRfcSize() const;

        bool isHeaderCached() const;
        bool isCached() const;

    protected:
        Storage& storage;
        Storage& httpStorage;

        string header_;
        string text_;
        string meta_;

        // HotFix rfcSize
        size_t rfcSize = 0;

        bool cached = false;
        bool headerCached_ = false;
    };

private:
    const std::string stid;
    std::shared_ptr<Storage> storage;
    std::shared_ptr<Storage> httpStorage;

    MetaParts meta_;
    InlineMessages inlm_;
    static const int inlineLevel_;

    HeaderTextCacher headerText;

    string whole_;
    bool isCachedWhole_ = false;
};

} // namespace mbody
} // namespace yimap
