#pragma once

#include <string>
#include <vector>
#include <list>

namespace yimap { namespace mbody {

struct MbodyData;

class MbodyStreamParser
{
public:
    enum class SkipPattern
    {
        Normal,
        Noskip
    };

    MbodyStreamParser(SkipPattern skipPattern = SkipPattern::Normal);

    void parse(const char* chunk, size_t length);
    void done()
    {
    }

    // HotFix rfcSize
    void parseRfcSize(std::string& xml);

    MbodyData takeData();

protected:
    bool takeChunk(size_t crlfSize = 0);
    // HotFix rfcSize
    size_t rfcSize = 0;

    struct CRLF
    {
        uint32_t size;
        bool needData;

        static CRLF trySkip(const std::string& data, size_t offset);
    };

protected:
    std::list<std::string> separators;
    std::list<bool> shouldSkip;
    std::string data;
    size_t offset = 0;
    std::vector<std::string> chunks;
};

struct MbodyData
{
    std::string meta;
    std::string header;
    std::string text;

    // HotFix rfcSize
    size_t rfcSize = 0;

    std::exception_ptr error;

    MbodyData(std::exception_ptr error = nullptr);

    bool takeMetaBody(std::string& meta, std::string& body);
    bool takeMetaHeader(std::string& meta, std::string& header);
    bool takeMetaHeaderText(std::string& meta, std::string& header, std::string& text);
    bool hasException() const
    {
        return error != nullptr;
    }
    size_t getRfcSize() const
    {
        return rfcSize;
    }
};

} // namespace mbody
} // namespace yimap
