#pragma once

#include <backend/mbody/storage/mbody_stream_parser.h>
#include <backend/backend_types.h>
#include <common/context.h>

#include <ymod_ratecontroller/rate_controller.h>

namespace yimap { namespace mbody {

class MulcagateStorage
{
    using RateControllerPtr = ymod_ratecontroller::rate_controller_ptr;

public:
    MulcagateStorage(
        RateControllerPtr rateController,
        const std::string& stid,
        const MbodyStorageOptions& storageOptions,
        ContextPtr context);

    bool get(std::string& msg, std::string& meta);
    bool get_header(std::string& header, std::string& meta);
    bool get_header_text(std::string& header, std::string& text, std::string& meta);
    bool get_part(const std::string& part_id, std::string& msg, std::string& meta);
    size_t get_rfc_size() const;
    std::string get_last_error() const;

protected:
    MbodyData loadByHttp(const std::string& part = "");
    std::string makeUrl(const std::string& type = "", const std::string& part = "") const;

protected:
    const std::string stid;
    const MbodyStorageOptions storageOptions;
    ContextPtr context;

    // HotFix rfcSize
    size_t rfcSize = 0;
    std::string lastError;

    RateControllerPtr rateController;
};

} // namespace mbody
} // namespace yimap
