#pragma once

#include <common/context.h>
#include <backend/mbody/types.h>

#include <boost/optional.hpp>

namespace yimap { namespace mbody {

using LengthOpt = boost::optional<std::size_t>;

class RawStorage
{
public:
    using Handler = std::function<void(std::string err, std::string body)>;

    virtual ~RawStorage()
    {
    }

    virtual void getMimeStructure(Handler handler) const = 0;

    virtual void get(Handler handler) const = 0;
    virtual void get(const std::size_t offset, LengthOpt length, Handler handler) const = 0;
};

using RawStoragePtr = std::shared_ptr<RawStorage>;

RawStoragePtr createRawStorage(
    const StorageOptionsConstPtr&,
    const ContextPtr&,
    const std::string& stid);

} // namespace mbody
} // namespace yimap
