#include "storage.h"

#include "mulcagate_storage.h"

#include <ymod_ratecontroller/rate_controller.h>
#include <yplatform/find.h>

namespace yimap { namespace mbody {

static const std::string MULCA2_PREFIX = "mulca:2:";

static inline string clearStid(const string& srcStid)
{
    auto stid = srcStid;
    auto pos = stid.find(MULCA2_PREFIX);
    if (pos != std::string::npos) stid.erase(pos, MULCA2_PREFIX.size());
    return stid;
}

std::shared_ptr<Storage> createStorage(
    const std::string& stid,
    const MbodyStorageOptions& storageOptions,
    ContextPtr context)
{
    return std::make_shared<Storage>(clearStid(stid), storageOptions, context);
}

//-----------------------------------------------------------------------------

Storage::Storage(
    const std::string& stid,
    const MbodyStorageOptions& storageOptions,
    ContextPtr context)
    : stid(stid)
{
    auto rcModule = yplatform::find<ymod_ratecontroller::rate_controller_module>("rate_controller");
    auto controller = rcModule->get_controller("mulcagate");
    mulcagateStorage =
        std::make_shared<MulcagateStorage>(controller, stid, storageOptions, context);
}

bool Storage::get(std::string& msg, std::string& meta)
{
    return mulcagateStorage->get(msg, meta);
}

bool Storage::get_header(std::string& header, std::string& meta)
{
    return mulcagateStorage->get_header(header, meta);
}

bool Storage::get_header_text(std::string& header, std::string& text, std::string& meta)
{
    return mulcagateStorage->get_header_text(header, text, meta);
}

bool Storage::get_part(const std::string& part_id, std::string& msg, std::string& meta)
{
    return mulcagateStorage->get_part(part_id, msg, meta);
}

size_t Storage::get_rfc_size() const
{
    return mulcagateStorage->get_rfc_size();
}

std::string Storage::get_last_error() const
{
    return mulcagateStorage->get_last_error();
}

} // namespace mbody
} // namespace yimap
