#pragma once

#include <common/context.h>
#include <backend/backend_types.h>

#include <yplatform/log.h>

namespace yimap { namespace mbody {

class LibmulcaStorage;
class MulcagateStorage;

class Storage : public yplatform::log::contains_logger
{
public:
    Storage(const std::string& stid, const MbodyStorageOptions& storageOptions, ContextPtr context);
    virtual ~Storage()
    {
    }

    const std::string& getStid() const
    {
        return stid;
    }

    bool get(std::string& msg, std::string& meta);
    bool get_header(std::string& header, std::string& meta);
    bool get_header_text(std::string& header, std::string& text, std::string& meta);
    bool get_part(const std::string& part_id, std::string& msg, std::string& meta);
    size_t get_rfc_size() const;

    std::string get_last_error() const;

protected:
    const std::string stid;

    std::shared_ptr<MulcagateStorage> mulcagateStorage;

    ContextPtr context;
};

std::shared_ptr<Storage> createStorage(
    const std::string& stid,
    const MbodyStorageOptions& storageOptions,
    ContextPtr context);

} // namespace mbody
} // namespace yimap
