#pragma once

#include <common/config.h>
#include <common/types.h>

#include <list>
#include <map>

namespace yimap {

namespace mbody {

struct asNumCmp
{
    bool operator()(const std::string& s1, const std::string& s2) const;
};

} // namespace mbody

using MetaAttributes = std::map<std::string, std::string>;
using MetaAttributesPtr = std::shared_ptr<MetaAttributes>;

using MetaParts = std::map<std::string, MetaAttributes, mbody::asNumCmp>;
using MetaPartsPtr = std::shared_ptr<MetaParts>;
using ConstMetaPartsPtr = std::shared_ptr<const MetaParts>;

using MetaLevel = std::list<std::string>;
using MetaLevelPtr = std::shared_ptr<MetaLevel>;

enum MAPolicy
{
    policyDefault,
    policyAttachment,
};

struct StorageOptions
{
    std::string stidTruncatePrefix;
    std::string extraAttrs;
};

using StorageOptionsConstPtr = std::shared_ptr<const StorageOptions>;

} // namespace yimap
