#include "meta_parser.h"
#include "utfizer.h"

#include <boost/regex.hpp>
#include <butil/StrUtils/ToLower.h>

namespace yimap {

MetaParser::MetaParser() : Expat("UTF-8"), start_handler(start)
{
    parserReset();
}

void MetaParser::start(void* me, const char* el, const char** attrs)
{
    if (strcmp(el, "part")) return;

    MetaParser* tclass = static_cast<MetaParser*>(me);
    MetaAttributes a;
    const char* id = NULL;
    for (int i = 0; attrs[i]; i += 2)
        if (strcmp(attrs[i], "id")) a[attrs[i]] = attrs[i + 1];
        else
            id = attrs[i + 1];
    MetaAttributes::iterator ai;
    for (ai = a.begin(); ai != a.end(); ai++)
    {
        size_t epos = 0;
        while ((epos = ai->second.find('\r', epos)) != std::string::size_type(-1))
            ai->second.erase(epos, 1);
        epos = 0;
        while ((epos = ai->second.find('\n', epos)) != std::string::size_type(-1))
            ai->second.erase(epos, 1);
    }
    ToLower lowercase;
    bool typeMessage = false;
    if ((ai = a.find("content_type.type")) != a.end())
    {
        std::transform(ai->second.begin(), ai->second.end(), ai->second.begin(), lowercase);
        if (ai->second == "message") typeMessage = true;
    }
    if ((ai = a.find("content_type.subtype")) != a.end())
    {
        std::transform(ai->second.begin(), ai->second.end(), ai->second.begin(), lowercase);
        if (typeMessage && !tclass->markAsLink && ai->second == "rfc822" && id)
            (*(tclass->inlmes))[id] = NULL;
    }
    if (tclass->markAsLink) a["link_only"] = "yes";
    if (id) (*(tclass->parts))[id] = a;
}

void MetaParser::parserReset()
{
    reset("UTF-8");
    setUserData(this);
    setStartElementHandler(start_handler);
}

int MetaParser::process(
    const std::string& source,
    MetaParts* mparts,
    mbody::InlineMessages* inlm,
    bool _markAsLink)
{
    if (!mparts || !inlm)
    {
        return METAPARSER_INVALIDPARAM;
    }
    if (source.empty()) return METAPARSER_OK;
    parts = mparts;
    inlmes = inlm;
    markAsLink = _markAsLink;
    std::string doc = source;
    boost::regex re("^<\\?xml.*encoding=\"([^\"]*)\".*\\?>$");
    boost::smatch res;
    std::string encoding = "utf-8";
    if (boost::regex_search(doc, res, re))
    {
        encoding = res[1];
    }
    UTFizer::process(encoding, doc);
    rc = parse(doc);
    if (rc != XML_STATUS_OK) return rc = METAPARSER_XMLERROR;
    return METAPARSER_OK;
}

std::string MetaParser::parserError()
{
    std::string errorStr;
    if (rc > 0)
    {
        std::ostringstream oss;
        oss << Iconv::error(rc) << " at offset " << rc;
        errorStr.assign(oss.str().c_str());
    }
    else if (!rc)
    {
        errorStr.assign("no error");
    }
    else if (rc == -2)
    {
        errorStr.assign("linked iconv can't make cp1251 -> utf-8 recoding");
    }
    else if (rc == -3)
    {
        errorStr.assign("unknown iconv error");
    }
    else if (rc == -11)
    {
        errorStr.assign("invalid input parameters");
    }
    else if (rc == -10)
    {
        errorStr.assign("xml parsing error: ");
        errorStr.append(error());
    }
    else
    {
        errorStr.assign("unknown error");
    }
    return errorStr;
}

} /* namespace yimap */
