#pragma once

#include <backend/mbody/message_access.h>
#include <butil/Expat.h>

namespace yimap {

#define METAPARSER_OK 0
#define METAPARSER_CANTRECODE (-2)
#define METAPARSER_UNKNOWN (-3)
#define METAPARSER_XMLERROR (-10)
#define METAPARSER_INVALIDPARAM (-11)

class MetaParser : private Expat
{
public:
    MetaParser();
    void parserReset();
    /**
     * process parser source string and returns result in *mparts
     * we wait source in cp1251 and returns content of *mparts in utf-8
     * returns: 0 - ok, !=0 - error
     */
    int process(
        const std::string& source,
        MetaParts* mparts,
        mbody::InlineMessages* inlm,
        bool _markAsLink);
    std::string parserError();

private:
    static void start(void* me, const char* el, const char** attrs);

private:
    MetaParts* parts;
    mbody::InlineMessages* inlmes;
    void (*start_handler)(void*, const char*, const char**);
    int rc;
    bool markAsLink;
};

} // namespace yimap
