#include "recognizer_wrapper.h"
#include "utf16.h"

#include <webmail-recognizer.h>

namespace yimap { namespace Recognizer {

const TWebmailRecognizer& instance()
{
    static const TWebmailRecognizer instance;
    return instance;
}

TextTraits recognize(const std::string& text)
{
    int code = 0;
    int lang = 0;
    const Result res(instance().AnalyzeText(text.c_str(), text.length(), code, lang));
    return res.succeeded() ? TextTraits(code, lang) : TextTraits();
}

CodesEnum tryRecognizeUnknown(const std::string& text)
{
    if (isValidUtf16(text))
    {
        return CODES_UTF16;
    }
    return CODES_UNSUPPORTED;
}

CodesEnum recognizeEncoding(const std::string& text)
{
    int code = 0;
    const Result res(instance().AnalyzeEncoding(text.c_str(), text.length(), code));
    if (res.succeeded())
    {
        const CodesEnum res = convertEnum(code, CODES_UNSUPPORTED, CODES_MAX);
        return (res == CODES_UNKNOWN) ? tryRecognizeUnknown(text) : res;
    }
    else
    {
        return CODES_UNSUPPORTED;
    }
}

}}
