#ifndef _YIMAP_COMMON_CONFIG_H_
#define _YIMAP_COMMON_CONFIG_H_

#include <string>
#include <memory>
#include <mutex>
#include <yplatform/time_traits.h>

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/optional.hpp>

namespace yimap {

namespace asio = boost::asio;
using std::string;
using std::wstring;

typedef std::shared_ptr<string> StringPtr;
typedef std::shared_ptr<const string> ConstStringPtr;

typedef std::function<void()> VoidFunction;

struct SessionInfo
{
    std::string local_address;
    unsigned short local_port;

    std::string remote_address;
    unsigned short remote_port;

    boost::posix_time::ptime sessionTime = boost::posix_time::second_clock::local_time();

    SessionInfo()
    {
    }

    template <typename EndPoint>
    SessionInfo(const EndPoint& local, const EndPoint& remote)
        : local_address(local.address().to_string())
        , local_port(local.port())
        , remote_address(remote.address().to_string())
        , remote_port(remote.port())
    {
    }
};

typedef std::unique_lock<std::mutex> std_lock;

namespace server {

class NetworkSession;

typedef boost::shared_ptr<NetworkSession> NetworkSessionPtr;
typedef boost::weak_ptr<NetworkSession> NetworkSessionWeakPtr;
typedef std::function<NetworkSessionPtr()> SessionPtrFunction;

}

}

#endif // _YIMAP_COMMON_CONFIG_H_
