#pragma once

#include <yplatform/task_context.h>
#include "log/logger.h"

namespace yimap {

struct AuthConfig
{
    std::string service;
    std::string domain;
    unsigned sid;
    bool allow_xlogin = false;
    bool force_encryption = false;

    void parse_ptree(const yplatform::ptree& data)
    {
        service = data.get("service", "pop");
        domain = data.get("domain", "yandex.ru");
        sid = data.get("sid", 2u);
        allow_xlogin = data.get("allow_xlogin", 0);
        force_encryption = data.get("force_encryption", 0);
    }
};

class Context : public yplatform::task_context
{
public:
    Context()
    {
    }
    virtual ~Context()
    {
    }

    // AUTH info
    AuthConfig auth_cfg;

    std::string username;
    std::string suid;
    std::string uid;
    std::string storage;
    std::string login;
    std::string email;
    std::string language;
    std::string country;
    std::string domainId;

    SessionInfo sessionInfo;

    virtual const std::string& get_name() const
    {
        static const std::string NAME = "yimap_context";
        return NAME;
    }
};

typedef boost::shared_ptr<Context> ContextPtr;

inline ShortSessionInfo createShortSessionInfo(Context& context)
{
    return ShortSessionInfo(
        context.uniq_id(),
        context.storage,
        context.uid,
        context.suid,
        context.login,
        context.username,
        context.language,
        context.country,
        context.domainId,
        context.sessionInfo.remote_address,
        context.sessionInfo.remote_port);
}

} // namespace yimap
