#include "helpers.h"
#include <boost/regex.hpp>

namespace yimap {

//-----------------------------------------------------------------------------
// Host-id helper struct

static std::string getHostName()
{
    char hostNameBuff[255];
    if (gethostname(hostNameBuff, sizeof(hostNameBuff)))
    {
        return "";
    }

    return std::string(hostNameBuff);
}

HostId::HostId(const std::string& hostName, const std::string& suffix)
    : hostName(hostName), suffix(suffix)
{
}

HostId HostId::parse(const std::string& hostName)
{
    static boost::regex hostnameRegexp("^[a-zA-Z]+-?([\\w-]*?)\\..*$");
    boost::smatch match;
    std::string suffix;
    if (boost::regex_match(hostName, match, hostnameRegexp))
    {
        suffix = match[1];
    }

    return HostId(hostName, suffix);
}

HostId HostId::create()
{
    // С++11 ensures thread safe initialization of static hostId
    static HostId hostId(HostId::parse(getHostName()));
    return hostId;
}

} // namespace yimap
