#include "log.h"

namespace yimap {

ClientsSpdLogPool clientsLogPool;
auto clientsLogRotate = boost::make_shared<ClientsSpdLogRotate>(clientsLogPool);

void startLogs(const yplatform::ptree& config)
{
    auto clientsLogFactory = std::make_shared<ClientsSpdLogFactory>(config);
    size_t maxPoolSize = config.get("log_settings.clients_log.max_pool_size", 100);
    clientsLogPool.init(maxPoolSize, clientsLogFactory);
}

void rotateLogs()
{
    clientsLogRotate->rotate();
}

void stopLogs()
{
}

} // namespace yimap
