#include "logger.h"

namespace yimap {

LogHelper::~LogHelper()
{
    if (flags & LH_LOG_DISCARD) return;
    if (hasData && logger)
    {
        logger->logString(sstream.str(), flags);
    }
}

LogHelper Logger::log(bool systemLog, bool errorLog)
{
    return LogHelper(*this, "", systemLog, errorLog);
}
LogHelper Logger::logError()
{
    return LogHelper(*this, "error: ", false, true, false);
}
LogHelper Logger::logEvent()
{
    return log(true);
}
LogHelper Logger::logWarning()
{
    return LogHelper(*this, "warning: ", false, false, true);
}

}
