#pragma once

#include "log_helper.h"
#include <common/config.h>

namespace yimap {

struct ShortSessionInfo
{
    ShortSessionInfo() = default;
    ShortSessionInfo(
        const std::string& uniqId,
        const std::string& storage,
        const std::string& uid,
        const std::string& suid,
        const std::string& login,
        const std::string& username,
        const std::string& language,
        const std::string& country,
        const std::string& domainId,
        const std::string& clientIp,
        size_t clientPort)
        : uniqId(uniqId)
        , storage(storage)
        , uid(uid)
        , suid(suid)
        , login(login)
        , username(username)
        , language(language)
        , country(country)
        , domainId(domainId)
        , clientIp(clientIp)
        , clientPort(clientPort)
        , cachedPrefix(uniqId + " [" + login + "," + uid + "," + clientIp + "," + storage + "] ")
    {
    }

    std::string uniqId;
    std::string storage;
    std::string uid;
    std::string suid;
    std::string login;
    std::string username;
    std::string language;
    std::string country;
    std::string domainId;
    std::string clientIp;
    size_t clientPort;

    string logPrefix() const
    {
        return cachedPrefix;
    }

private:
    string cachedPrefix;
};

typedef boost::optional<string> StringOpt;

class Logger
{
public:
    virtual ~Logger()
    {
    }

    virtual void updateSessionInfo(const ShortSessionInfo& newSessionInfo) = 0;
    virtual void enableClientLog()
    {
    }

    virtual LogHelper log(bool systemLog = false, bool errorLog = false);
    virtual LogHelper logError();
    virtual LogHelper logEvent();
    virtual LogHelper logWarning();

    virtual void logString(const string&, size_t flags = 0) = 0;
    virtual void logTiming(const string& /* message */) = 0;
    virtual void logCommand(const string&) const = 0;
    virtual void logTraffic(const string& /* message */) = 0;

    virtual LogHelper logDebug() = 0;
    virtual LogHelper logDebugNet() = 0;
};

} // namespace yimap
