#ifndef _YIMAP_NETWORK_CLIENT_STREAM_H_
#define _YIMAP_NETWORK_CLIENT_STREAM_H_

#include <common/config.h>
#include <sstream>
#include <yplatform/net/streamable.h>

namespace yimap { namespace server {

struct DebugRecordTag
{
    DebugRecordTag()
    {
    }
    DebugRecordTag(const string& message) : data(message)
    {
    }
    string data;
};

class ClientSreamImpl
{
public:
    explicit ClientSreamImpl(NetworkSessionPtr session) : session(session)
    {
    }
    ~ClientSreamImpl();

    template <typename T>
    ClientSreamImpl& operator<<(const T& t)
    {
        outstream << t;
        return *this;
    }

    ClientSreamImpl& operator<<(const DebugRecordTag& t)
    {
        debugstream << t.data;
        return *this;
    }

protected:
    NetworkSessionPtr session;
    std::ostringstream outstream;
    std::ostringstream debugstream;
};

class ClientStream
{
public:
    ClientStream(NetworkSessionPtr session) : impl(new ClientSreamImpl(session))
    {
    }
    ClientStream(ClientStream&& other) : impl(std::move(other.impl))
    {
    }
    ClientStream() = delete;
    ClientStream(const ClientStream&) = delete;
    ClientStream& operator=(const ClientStream&) = delete;

    template <typename T, class = typename std::enable_if<std::is_fundamental<T>::value>::type>
    ClientStream& operator<<(T t)
    {
        *impl << t;
        return *this;
    }

    ClientStream& operator<<(const std::string& str)
    {
        *impl << str;
        return *this;
    }

    ClientStream& operator<<(const DebugRecordTag& t)
    {
        *impl << t;
        return *this;
    }

    template <typename iterator>
    ClientStream& operator<<(const boost::iterator_range<iterator>& t)
    {
        *impl << t;
        return *this;
    }

protected:
    std::unique_ptr<ClientSreamImpl> impl;
};

} // namespace server
} // namespace yimap

#endif // _YIMAP_NETWORK_CLIENT_STREAM_H_
