#ifndef _YIMAP_NETWORK_PTOTOCOL_SESSION_H_
#define _YIMAP_NETWORK_PTOTOCOL_SESSION_H_

#include <common/config.h>
#include <common/log/logger.h>
#include <network/session_fwd.h>

namespace yimap { namespace server {

//-----------------------------------------------------------------------------
// Base class for protocol session

class ProtocolSessionBase
{
public:
    virtual ~ProtocolSessionBase()
    {
    }

    virtual void init(const SessionInfo& sessionInfo) = 0;

    virtual void greetings() = 0;
    virtual void processData(string&& chunk) = 0;

    virtual void onTls(bool on, const string& chipher) = 0;
    virtual void onReadError(const boost::system::error_code& e) = 0;
    virtual void onWriteError(const boost::system::error_code& e) = 0;
    virtual void onSendClientStream(
        const yplatform::net::buffers::const_chunk_buffer& s,
        bool skip_log,
        const string& debugRecord) = 0;

    virtual void autologout() = 0;
    virtual void onShutdown()
    {
    }

    virtual ContextPtr getContext() = 0;
    virtual Logger& getLogger() = 0;
};

} // namespace server
} // namespace yimap

#endif // _YIMAP_NETWORK_PTOTOCOL_SESSION_H_
