#pragma once

#include <common/config.h>
#include <common/helpers/helpers.h>
#include <network/client_stream.h>

namespace yimap {

class Logger;
class Context;
typedef boost::shared_ptr<Context> ContextPtr;

using yplatform::time_traits::time_point;
using yplatform::time_traits::duration;
using Timer = yplatform::time_traits::timer;
using TimerPtr = yplatform::time_traits::timer_ptr;

namespace server {

//-----------------------------------------------------------------------------
// Network events

struct NetworkEventImpl
{
    NetworkEventImpl(const string& name) : name(name)
    {
    }
    virtual ~NetworkEventImpl()
    {
    }
    const std::string name;
};

#define DEFINE_EVENT_IMPL(ClassName)                                                               \
    struct ClassName : public NetworkEventImpl                                                     \
    {                                                                                              \
        ClassName() : NetworkEventImpl(#ClassName)                                                 \
        {                                                                                          \
        }                                                                                          \
    };

DEFINE_EVENT_IMPL(StartReader)
DEFINE_EVENT_IMPL(ResumeReading)
DEFINE_EVENT_IMPL(StartTls)
DEFINE_EVENT_IMPL(ShutdownSession)

struct ChangeTimeouts : public NetworkEventImpl
{
    enum Class
    {
        Init,
        Default,
        Idle,
        Respond,
        Exit
    };

    const Class data;
    ChangeTimeouts(Class data) : NetworkEventImpl("ChangeTimeouts"), data(data)
    {
    }
    ChangeTimeouts(const ChangeTimeouts& that) : NetworkEventImpl("ChangeTimeouts"), data(that.data)
    {
    }

    ChangeTimeouts(ChangeTimeouts&& that) = delete;
    ChangeTimeouts& operator=(ChangeTimeouts&&) = delete;
};

struct ExecEvent : public NetworkEventImpl
{
    ExecEvent(VoidFunction hook) : NetworkEventImpl("ExecEvent"), hook(hook)
    {
    }
    VoidFunction hook;
};

typedef std::shared_ptr<NetworkEventImpl> NetworkEvent;

struct NetworkEventResult
{
};

//-----------------------------------------------------------------------------
// Base session class

class NetworkSession : public yplatform::net::streamable
{
public:
    virtual ~NetworkSession(){};

    virtual bool isOpen() const = 0;
    virtual ClientStream clientStream() = 0;

    virtual void sendClientStream(
        const yplatform::net::buffers::const_chunk_buffer& buffer,
        bool skip_log,
        const string& extraLogMessage) = 0;

    virtual void postEvent(NetworkEvent event) = 0;
    virtual void postOnStrand(VoidFunction) = 0;

    virtual TimerPtr createTimer(uint32_t milliseconds, VoidFunction hook) = 0;

    virtual ContextPtr getContext() = 0;
    virtual Logger& getLogger() = 0;
    virtual std::string hostname() = 0;
};

} // namespace server

using server::ClientStream;
using server::NetworkSessionPtr;
using server::NetworkSessionWeakPtr;

} // namespace yimap
