#pragma once

#include <processor/config.h>
#include <processor/processor.h>
#include <processor/module_context.h>
#include <processor/logger.h>
#include <network/session_fwd.h>

#include <map>

namespace ypop {

using yimap::server::NetworkSessionPtr;
class processor_impl;

typedef ypop::pop_context session_context_t;
typedef ypop::pop_context_ptr session_context_ptr;
typedef session_context_t::PopSessionState session_state_t;

struct PopCommand
{
    yplatform::future::promise<response> prom;
    session_context_ptr context;
    task_context_ptr statistic;
    request_t req;
    NetworkSessionPtr ostr;
    std::string command;

    PopCommand(
        const request_t& req,
        session_context_ptr context,
        NetworkSessionPtr ostr,
        processor_stats_ptr stats);

    yplatform::const_task_context_ptr get_task_context() const
    {
        return context;
    }

    // Returns string like ". sc=LZivkqb04mI1" for error output ending.
    string get_uniq_id_ending()
    {
        return context ? yimap::createErrorSuffix(context->uniq_id()) : "";
    }

    string to_log_string(bool log_cmd = true) const;

    std::string messageIndex() const
    {
        return (*req)[1];
    }

    void remember();
    void rememberResponse(std::string&& resp);

    void out_statistic();
    void out_server_error();
    void out_mailbox_busy();
    void out_incorrect_command(const string& usage = "");
    void out_incorrect_msgid();
    void out_goobye();
};

typedef std::shared_ptr<PopCommand> pop_args_ptr;

typedef void (processor_impl::*cmd_processor_t)(pop_args_ptr args);

struct cmd_entry
{
    cmd_entry() : cmd_ptr(0), state(session_context_t::INVALID)
    {
    }

    cmd_entry(cmd_processor_t cmd_ptr_, session_state_t state_) : cmd_ptr(cmd_ptr_), state(state_)
    {
    }

    cmd_processor_t cmd_ptr;
    session_state_t state;
};

} // namespace ypop
