#include <processor/processor_impl.h>
#include <processor/config.h>

namespace ypop {

void processor_impl::cmd_noop(pop_args_ptr args)
{
    args->ostr->clientStream() << "+OK noop\r\n";
    args->prom.set(ProcessorResult::SUCCESS);
}

void processor_impl::cmd_capa(pop_args_ptr args)
{
    args->ostr->clientStream() << "+OK Capability list follows\r\n"
                               << "STLS\r\n"
                               << "TOP\r\n"
                               << "USER\r\n"
                               << "LOGIN-DELAY 60\r\n"
                               << "PIPELINING\r\n"
                               << "EXPIRE NEVER\r\n"
                               << "UIDL\r\n"
                               << "RESP-CODE\r\n"
                               << "AUTH-RESP-CODE\r\n"
                               << "IMPLEMENTATION Yandex\r\n"
                               << ".\r\n";
    args->prom.set(ProcessorResult::SUCCESS);
}

void processor_impl::cmd_stat(pop_args_ptr args)
{
    args->out_statistic();
}

void processor_impl::cmd_vers(pop_args_ptr args)
{
    args->ostr->clientStream() << "+OK "
                               << "1.0.0-0"
                               << ".\r\n";
    args->prom.set(ProcessorResult::SUCCESS);
}

void processor_impl::cmd_list(pop_args_ptr args)
{
    if (args->req->size() > 2) return args->out_incorrect_command("list [msg-id]");

    if (args->req->size() == 2)
    {
        ++args->context->msize_requested;
        ypop::message_entry* msg;
        if (!(msg = get_msg_entry(args->messageIndex(), args->context)))
            return args->out_incorrect_msgid();

        args->ostr->clientStream() << "+OK " << args->messageIndex() << " " << msg->size << "\r\n";
    }
    else
    {
        args->context->list_requested = true;
        args->ostr->clientStream() << "+OK " << args->context->messages->good_number << " "
                                   << args->context->messages->good_size << "\r\n";
        std::size_t msg_id = 1;

        for (ypop::MessageVector::iterator i = args->context->messages->begin(),
                                           iend = args->context->messages->end();
             i != iend;
             ++i, ++msg_id)
        {
            if (i->is_deleted) continue;
            args->ostr->clientStream() << msg_id << " " << i->size << "\r\n";
        }
        args->ostr->clientStream() << ".\r\n";
    }
    args->prom.set(ProcessorResult::SUCCESS);
}

void processor_impl::cmd_uidl(pop_args_ptr args)
{
    if (args->req->size() > 2) return args->out_incorrect_command("uidl [msg-id]");

    if (args->req->size() == 2)
    {
        ++args->context->muidl_requested;
        ypop::message_entry* msg;
        if (!(msg = get_msg_entry(args->messageIndex(), args->context)))
            return args->out_incorrect_msgid();

        args->ostr->clientStream() << "+OK " << args->messageIndex() << " " << msg->uidl << "\r\n";
    }
    else
    {
        args->context->list_requested = true;
        args->ostr->clientStream() << "+OK " << args->context->messages->good_number << " "
                                   << args->context->messages->good_size << "\r\n";
        std::size_t msg_id = 1;

        for (ypop::MessageVector::iterator i = args->context->messages->begin(),
                                           iend = args->context->messages->end();
             i != iend;
             ++i, ++msg_id)
        {
            if (i->is_deleted) continue;
            args->ostr->clientStream() << msg_id << " " << i->uidl << "\r\n";
        }
        args->ostr->clientStream() << ".\r\n";
    }
    args->prom.set(ProcessorResult::SUCCESS);
}

} // namespace ypop
