#ifndef _YPOP_PROCESSOR_LOGGER_H_
#define _YPOP_PROCESSOR_LOGGER_H_

#include <yplatform/log.h>

namespace ypop {

class custom_loggers
{
public:
    custom_loggers()
        : error_log_(YGLOBAL_LOG_SERVICE, "error_log"), typed_log_(YGLOBAL_LOG_SERVICE, "typed_log")
    {
    }

    yplatform::log::source& error_log() const
    {
        return error_log_;
    }
    yplatform::log::tskv_logger& typed_log() const
    {
        return typed_log_;
    }

private:
    mutable yplatform::log::source error_log_;
    mutable yplatform::log::tskv_logger typed_log_;
};

#define service_log_error(args, msg)                                                               \
    try                                                                                            \
    {                                                                                              \
        std::ostringstream __os__;                                                                 \
        __os__ << (args).to_log_string() << " " << msg;                                            \
        TASK_LOG((args).get_task_context(), error) << __os__.str();                                \
        YLOG(this->proc_loggers().error_log(), error)                                              \
            << (args).get_task_context()->uniq_id() << " " << __os__.str();                        \
    }                                                                                              \
    catch (...)                                                                                    \
    {                                                                                              \
    }

#define service_log_error_context(context_ptr, msg)                                                \
    try                                                                                            \
    {                                                                                              \
        std::ostringstream __os__;                                                                 \
        __os__ << context_ptr->to_log_string() << " " << msg;                                      \
        TASK_LOG(context_ptr, error) << __os__.str();                                              \
        YLOG(this->proc_loggers().error_log(), error)                                              \
            << context_ptr->uniq_id() << " " << __os__.str();                                      \
    }                                                                                              \
    catch (...)                                                                                    \
    {                                                                                              \
    }

}

#endif // _YPOP_PROCESSOR_LOGGER_H_
