#include <processor/pop_backend.h>
#include <processor/transliterate.h>

namespace ypop {

inline bool IsEmptyFolder(const message_entry& message)
{
    return message.folder_name.empty();
}

//-----------------------------------------------------------------------------

MessageLoader::MessageLoader(pop_context& context, PopSettingsPtr settings)
    : popContext(context), settings_(settings), messages(context.messages)
{
}

macs::Label MessageLoader::getSeenLabel()
{
    if (!seenLabel)
    {
        seenLabel = labels().getLabelBySymbol(macs::Label::Symbol::seen_label);
    }
    return *seenLabel;
}

MessageListPtr MessageLoader::getMessages()
{
    if (!exception.empty())
    {
        throw std::runtime_error(exception);
    }
    return messages;
}

void MessageLoader::postprocessMessages()
{
    for (message_entry& message : *messages)
    {
        // We had store fid inside messages.folder_name
        string fid = message.folder_name;
        message.folder_name = "";
        if (folders().existFolder(fid))
        {
            auto folderSet = folders().getAllFolders();
            string srcFolderName = folderSet.getPath(folderSet.at(fid)).toString();
            messageFolder(srcFolderName, message);
        }
        message.size += getMessageExtraSize(message);
    }
    MessageVector::iterator last =
        std::remove_if(messages->begin(), messages->end(), IsEmptyFolder);
    size_t remains = last - messages->begin();
    messages->resize(remains);
    messages->cashData();
}

size_t MessageLoader::getMessageExtraSize(const ypop::message_entry& ind)
{
    size_t headers_size = 0;
    headers_size += POP_HEADER_FOLDER_NAME.length() + ind.folder_name.length() + 2;
    if (popContext.settings.spamEnable && ind.is_spam)
    {
        headers_size += POP_HEADER_SPAM_FLAG.length() + 2;
        if (popContext.settings.spamSubjectMarkEnable)
            headers_size += POP_HEADER_SPAM_SUBJECT.length() + 2;
    }
    return headers_size;
}

void MessageLoader::messageFolder(const string& srcName, message_entry& message)
{
    string name =
        (settings_->delivery_folder_name == srcName ? settings_->spam_folder_name : srcName);
    std::map<string, string>::const_iterator i = folder_cash_.find(name);
    if (i != folder_cash_.end())
    {
        message.folder_name = i->second;
        return;
    }
    if (transliterate(name, message.folder_name))
        folder_cash_.insert(std::make_pair(name, message.folder_name));
}

} // namespace ypop
