#include "pop_context.h"

namespace ypop {

std::string pop_context::state_name() const
{
    switch (state)
    {
    case START:
        return "START";
    case NAME:
        return "NAME";
    case TRANS:
        return "TRANS";
    case QUIT:
        return "QUIT";
    default:
        return "INVALID";
    }
}

std::string pop_context::to_log_string() const
{
    std::ostringstream os;
    os << "client=" << sessionInfo.remote_address << ':' << sessionInfo.remote_port;
    os << " state=" << state_name();

    if (state != ypop::pop_context::START) os << " user=" << login;

    if (!command.empty()) os << " cmd=" << command;

    return os.str();
}

void pop_context::addHistoryEntry(std::string&& entry)
{
    LOCK_POP_CONTEXT(*this);
    command_history.emplace_back(std::move(entry));
}

} // namespace ypop
