#ifndef _YPOP_PROCESSOR_H_
#define _YPOP_PROCESSOR_H_

#include <yplatform/active/object.h>
#include <yplatform/module_registration.h>
#include <yplatform/net/streamable.h>

#include <processor/pop_context.h>
#include <processor/config.h>
#include <network/session_fwd.h>

#include <boost/lexical_cast.hpp>
#include <string>
#include <vector>

namespace ypop {

using yimap::server::NetworkSessionPtr;
typedef bool result_t;

struct ProcessorResult
{
    enum ReturnCodes
    {
        FAILURE,
        SUCCESS,
        START_TLS,
        FAILURE_CLOSE
    };

    ProcessorResult(ReturnCodes code = FAILURE) : result_code(code)
    {
    }

    ProcessorResult(ReturnCodes code, const request_t& request)
        : result_code(code), source_request(request)
    {
    }

    ReturnCodes result_code;
    request_t source_request;
};

inline std::string toString(ProcessorResult::ReturnCodes code)
{
    switch (code)
    {
    case ProcessorResult::FAILURE:
        return "failure";
    case ProcessorResult::FAILURE_CLOSE:
        return "failure_close";
    case ProcessorResult::START_TLS:
        return "start_tls";
    case ProcessorResult::SUCCESS:
        return "success";
    default:
        return "unknown";
    }
}

typedef ProcessorResult response;

class Processor : public yplatform::module
//              , private boost::noncopyable
{
public:
    Processor()
    {
    }
    virtual ~Processor()
    {
    }

    virtual void process(
        const request_t& req,
        ypop::pop_context_ptr context,
        NetworkSessionPtr ostr,
        const yplatform::active::ptime& deadline = boost::posix_time::max_date_time) = 0;
};

} // namespace ypop

#endif // _YPOP_PROCESSOR_H_
