#pragma once

#include <yplatform/ptree.h>
#include <backend/backend_types.h>

namespace ypop {

struct LoginSettings
{
    bool userJournalLogEnable;
};

struct PopSettings
{
    PopSettings(const yplatform::ptree& xml)
        : spam_folder_name(xml.get("mbox_map.spam", "Спам"))
        , delivery_folder_name(xml.get("mbox_map.delivery", "Рассылки"))
        , pop_mdb_prefix(xml.get("pop_mdb_prefix", "pop_"))
        , mark_read_batch_size(xml.get("mark_read_batch_size", 0))
        , retr_wait_max(xml.get("retr_wait_max", 0))
        , enable_bb_block(xml.get("enable_bb_block", 0) != 0)
        , hide_deleted_messages(xml.get("hide_deleted_messages", 0) != 0)
        , ssl_only(xml.get("ssl_only", 0) != 0)
        , mulcaMaxFailures(xml.get("mulca_max_failures", 5))
        , mulcaFailureTimout(xml.get("mulca_failure_timout", 1000))
        , mbodyStorageOptions(
              { xml.get("mbody_storage.mulcagate.host", ""),
                xml.get("mbody_storage.mulcagate.attrs", ""),
                yplatform::time_traits::duration::max(),
                xml.get("mbody_storage.backend_type.both_mulca_percent", 0u),
                xml.get("mbody_storage.backend_type.both_mds_percent", 0u),
                xml.get("mbody_storage.backend_type.mds_percent", 0u),
                xml.get("mbody_storage.backend_type.process_non_empty_mimes_by_mds", false),
                0 })
        , loginSettings({ xml.get("login_settings.user_journal_log_enable", false) })
    {
        int mulcagateTimeout = xml.get("mbody_storage.mulcagate.timeout", 0);
        if (mulcagateTimeout > 0)
        {
            mbodyStorageOptions.mulcagateTimeout =
                yplatform::time_traits::milliseconds(mulcagateTimeout);
        }
    }

    string spam_folder_name;
    string delivery_folder_name;

    string pop_mdb_prefix;

    // Number of mids pass during wmi_mark_read call. If zero, it`s ok. One mid per one call.
    size_t mark_read_batch_size;
    // Length of max pop3 wait interval int RETR or TOP command in milliseconds
    int retr_wait_max;

    bool enable_bb_block;
    bool hide_deleted_messages;
    bool ssl_only;

    int mulcaMaxFailures;
    int mulcaFailureTimout;

    yimap::MbodyStorageOptions mbodyStorageOptions;

    LoginSettings loginSettings;
};

typedef boost::shared_ptr<PopSettings> PopSettingsPtr;

} // namespace ypop
