#include <map>
#include <sstream>
#include <locale>
#include <iostream>
#include <cstring>
#include <inttypes.h>

#include <processor/processor.h>

namespace ypop {

static const uint16_t utf8_table[] = {
    0xd0b0, 0xd0b1, 0xd0b2, 0xd0b3, 0xd0b4, 0xd0b5, 0xd191, 0xd0b6, 0xd0b7, 0xd0b8, 0xd0b9,
    0xd0ba, 0xd0bb, 0xd0bc, 0xd0bd, 0xd0be, 0xd0bf, 0xd180, 0xd181, 0xd182, 0xd183, 0xd184,
    0xd185, 0xd186, 0xd187, 0xd188, 0xd189, 0xd18a, 0xd18b, 0xd18c, 0xd18d, 0xd18e, 0xd18f,

    0xd090, 0xd091, 0xd092, 0xd093, 0xd094, 0xd095, 0xd081, 0xd096, 0xd097, 0xd098, 0xd099,
    0xd09a, 0xd09b, 0xd09c, 0xd09d, 0xd09e, 0xd09f, 0xd0a0, 0xd0a1, 0xd0a2, 0xd0a3, 0xd0a4,
    0xd0a5, 0xd0a6, 0xd0a7, 0xd0a8, 0xd0a9, 0xd0aa, 0xd0ab, 0xd0ac, 0xd0ad, 0xd0ae, 0xd0af
};

static const char* const ascii_table[] = {
    "a", "b", "v", "g", "d", "e",  "e",  "zh", "z",    "i",    "y", "k", "l", "m",  "n",  "o",  "p",
    "r", "s", "t", "u", "f", "h",  "ts", "ch", "sh",   "shch", "'", "i", "'", "e",  "yu", "ya", "A",
    "B", "V", "G", "D", "E", "E",  "ZH", "Z",  "I",    "Y",    "K", "L", "M", "N",  "O",  "P",  "R",
    "S", "T", "U", "F", "H", "TS", "CH", "SH", "SHCH", "'",    "I", "'", "E", "YU", "YA"
};

struct transliterate_table
{
    transliterate_table()
    {
        const unsigned table_size = sizeof(utf8_table) / sizeof(uint16_t);
        for (unsigned i = 0; i < table_size; ++i)
            data.insert(std::make_pair(utf8_table[i], ascii_table[i]));
    }
    std::map<uint16_t, const char*> data;
};

const transliterate_table ttable;

string::size_type get_symbol_size(const string& in, string::size_type ibgn)
{
    string::size_type result = 0;
    uint8_t symbol_ = static_cast<uint8_t>(in[ibgn]);
    for (uint8_t BIT = 0x80; symbol_ & BIT; BIT >>= 1, ++result)
        ;

    if (!result) result = 1;

    return result;
}

bool transliterate(const string& in, string& out)
{
    if (in.empty()) return false;

    std::locale loc;

    bool last_is_upper_multi = false;
    size_t last_tr_len = 0;
    for (string::size_type i = 0, length = in.length(); i < length; ++i)
    {
        string::size_type to_copy = get_symbol_size(in, i);
        if (to_copy == 2) to_copy = ((i == length - 1) ? 2 : 0);
        if (to_copy)
        {
            if (to_copy == 1) out.push_back(in[i]);
            i += (to_copy - 1);
            last_is_upper_multi = false;
            continue;
        }

        uint16_t symbol = 0x100 * static_cast<uint8_t>(in[i]) + static_cast<uint8_t>(in[i + 1]);
        std::map<uint16_t, const char*>::const_iterator ret = ttable.data.find(symbol);

        if (ret == ttable.data.end())
        { // not found
          // out.push_back( in[i] );
          // out.push_back( in[i + 1] );
        }
        else
        {
            out.append(ret->second);

            size_t trLen = ::strlen(ret->second);
            // Normalize words like "CHernoviki" to "Chernoviki"

            if (last_is_upper_multi && std::islower(*ret->second))
            {
                string::reverse_iterator rit = out.rbegin();
                rit += trLen;
                for (size_t z = 0; z < (last_tr_len - 1); ++z, ++rit)
                    *rit = std::tolower(*rit);
                last_is_upper_multi = false;
            }
            else if (trLen > 1)
            {
                bool textStart = (i == 0);
                bool textEnd = ((i + 2) == length);
                bool wordStart = (textStart || (!std::isalpha(in[i - 1])));
                last_is_upper_multi = wordStart && !textEnd && std::isupper(*ret->second);
                last_tr_len = trLen;
            }
        }
        ++i;
    }

    return true;
}

} // namespace ypop
