#ifndef _POP3_COMMAND_PARSER_H_
#define _POP3_COMMAND_PARSER_H_

#include <string>
#include <vector>
#include <algorithm>

namespace ypop {

template <typename value_type>
bool is_command_splitter(value_type c)
{
    return c == '\r' || c == '\n';
}

template <typename value_type>
bool is_lexem_splitter(value_type c)
{
    return c == ' ' || c == '\t';
}

template <typename Cont>
bool parse_command(const std::string& data, Cont& lexems, std::size_t& cmd_lenght)
{
    auto begin = data.begin();
    auto end = data.end();
    typename Cont::value_type lexem;
    typename Cont::value_type::value_type symbol;

    cmd_lenght = 0;
    std::size_t cmd_len = 0;

    for (auto i = begin; i != end; ++i, ++cmd_len)
    {
        symbol = *i;
        bool command_splitter = is_command_splitter(symbol);
        bool lexem_splitter = is_lexem_splitter(symbol);
        if (command_splitter || lexem_splitter)
        {
            if (!lexem.empty())
            {
                lexems.push_back(lexem);
                lexem.clear();
                begin = i;
                cmd_lenght = cmd_len;
            }
            if (!command_splitter) continue;

            bool isBeginNewLine = false;
            do
            {
                if (isBeginNewLine && *i == '\n') isBeginNewLine = false;

                if (*i == '\r') isBeginNewLine = true;

                ++i;
                ++cmd_len;
            } while (i != end && is_command_splitter(*i));

            if (isBeginNewLine) return false;

            begin = i;
            cmd_lenght = cmd_len;
            if (lexems.size())
            {
                typename Cont::iterator i_first_lexem;
                i_first_lexem = lexems.begin();
                std::transform(
                    i_first_lexem->begin(),
                    i_first_lexem->end(),
                    i_first_lexem->begin(),
                    ::tolower);
            }
            return true;
        }
        lexem.push_back(symbol);
    }
    return false;
}

} // namespace pop

#endif // _POP3_COMMAND_PARSER_H_
