#ifndef _POP3_LOGGER_H_
#define _POP3_LOGGER_H_

#include <common/log/logger.h>

namespace ypop {

using yimap::LogHelper;
using yimap::ShortSessionInfo;

class Pop3Logger : public yimap::Logger
{
public:
    Pop3Logger(const ShortSessionInfo& sessionInfo)
        : sessionInfo(sessionInfo)
        , mainLog(YGLOBAL_LOG_SERVICE, "global")
        , errorLog(YGLOBAL_LOG_SERVICE, "error_log")
        , trafficLog(YGLOBAL_LOG_SERVICE, "traffic_log")
    {
    }

    virtual void updateSessionInfo(const ShortSessionInfo& newSessionInfo)
    {
        sessionInfo = newSessionInfo;
    }

    virtual void logString(const std::string& message, size_t flags)
    {
        if (flags & LogHelper::LH_LOG_SYSTEM)
        {
            YLOG(mainLog, error) << sessionInfo.logPrefix() << message;
        }

        if (flags & LogHelper::LH_LOG_ERROR)
        {
            YLOG(errorLog, error) << sessionInfo.logPrefix() << message;
        }
    }

    virtual void logTiming(const std::string&)
    {
    }
    virtual void logAuth(const std::string&)
    {
    }
    virtual void logCommand(const std::string&) const
    {
    }

    virtual void logTraffic(const std::string& message)
    {
        YLOG(trafficLog, debug) << sessionInfo.logPrefix() << message;
    }

    virtual LogHelper logDebug()
    {
        return LogHelper("debug: ", LogHelper::LH_LOG_DEBUG, *this);
    }
    virtual LogHelper logDebugNet()
    {
        return LogHelper("debug_net: ", LogHelper::LH_LOG_DEBUG, *this);
    }

private:
    ShortSessionInfo sessionInfo;
    mutable yplatform::log::source mainLog;
    mutable yplatform::log::source errorLog;
    mutable yplatform::log::source trafficLog;
};

} // namespace ypop

#endif // _POP3_LOGGER_H_
