#ifndef _POP3_SESSION_H_
#define _POP3_SESSION_H_

#include <network/settings.h>
#include <network/protocol_session_base.h>

#include <server/pop3_logger.h>
#include <processor/pop_context.h>

namespace ypop {

using yimap::server::ServerSettings;
using yimap::server::SessionPtrFunction;

class Processor;
struct ProcessorResult;

class Pop3Session : public yimap::server::ProtocolSessionBase
{
public:
    Pop3Session(const ServerSettings& settings, SessionPtrFunction sessionHook);
    ~Pop3Session();

    virtual void init(const yimap::SessionInfo& sessionInfo);

    virtual void greetings();
    virtual void processData(std::string&& chunk);

    virtual void onTls(bool on, const std::string& chipher);
    virtual void onReadError(const boost::system::error_code& e);
    virtual void onWriteError(const boost::system::error_code& e);
    virtual void onSendClientStream(
        const yplatform::net::buffers::const_chunk_buffer&,
        bool,
        const string&)
    {
    }

    virtual yimap::ContextPtr getContext()
    {
        return context;
    }
    virtual yimap::Logger& getLogger()
    {
        return sessionLogger;
    }

    virtual void autologout();
    virtual void onShutdown();

protected:
    void executeCommand(const request_t& cmd);

protected:
    pop_context_ptr context;
    const ServerSettings& settings;
    Pop3Logger sessionLogger;
    SessionPtrFunction networkSession;
    boost::shared_ptr<Processor> popProcessor;

    std::string buffer;
};

} // namespace ypop

#endif // _POP3_SESSION_H_
