#include <server/server.h>

namespace ypop {

impl::impl() : yplatform::net::server_module<ProtocolSession<Pop3Session>>("pop3_server")
{
    L_(debug) << "pop_server task instaniated";
}

impl::~impl()
{
    L_(debug) << "pop_server task destroyed";
    server_->abort_server();
}

void impl::init(const yplatform::ptree& xml)
{
    if (!open_server(xml)) throw std::runtime_error("invalid pop3 server options");
}

void impl::fini(void)
{
    server_->abort_server();
}

void impl::start(void)
{
    run_server();
}

void impl::stop()
{
    server_->stop_server();
}

}
DEFINE_SERVICE_OBJECT(ypop::impl)
