#ifndef _YPOP_SERVER_SESSION_H_
#define _YPOP_SERVER_SESSION_H_

#include <boost/enable_shared_from_this.hpp>
#include <boost/thread/locks.hpp>
#include <boost/thread/mutex.hpp>
#include <yplatform/net/server_session.h>
#include <yplatform/net/line_filter.h>

#include <server/pop3_session.h>
#include <processor/config.h>
#include <processor/processor.h>

namespace ypop {

class Session
    : public yplatform::net::server_session<yplatform::net::line_filter, ServerSettings>
    , public BaseSession
    , public boost::enable_shared_from_this<Session>
{
    typedef std::vector<string> pop_command_t;
    typedef yplatform::net::server_session<yplatform::net::line_filter, ServerSettings> base_t;
    typedef yplatform::net::output_buffer_sequence<yplatform::net::buffers::const_chunk_buffer>
        output_queue_t;
    typedef boost::mutex mutex_t;
    typedef boost::unique_lock<mutex_t> lock_t;

public:
    Session(yplatform::net::base_service* service, const ServerSettings& settings);
    ~Session()
    {
    }

    void send_client_stream(yplatform::net::buffers::const_chunk_buffer const& s);
    yplatform::net::streamer_wrapper client_stream();

    virtual boost::shared_ptr<yplatform::net::streamable> streamablePtr()
    {
        return shared_from_this();
    }
    virtual yplatform::net::streamer_wrapper clientStream()
    {
        return client_stream();
    }

    virtual void startTls()
    {
        tls_start_delayed = true;
    }
    virtual bool startWriter();
    virtual void startReader();
    virtual void shutdown(bool graceful);
    virtual yplatform::net::timer_ptr createTimer(uint32_t milliseconds, yimap::VoidFunction hook);
    virtual std::shared_ptr<boost::asio::strand> createStrand()
    {
        return std::make_shared<boost::asio::strand>(*get_io());
    }
    virtual string logPrefix()
    {
        return get_log_prefix();
    }

private:
    void core_open();
    void start_session(const boost::system::error_code& e);

    void handle_tls_handshake(const boost::system::error_code& e);
    void handle_write(const boost::system::error_code& e, std::size_t bytes);
    void handle_quit(const boost::system::error_code& e, std::size_t bytes);
    void handle_read(const boost::system::error_code& e, std::size_t bytes, buffer_ptr buff);

    void processData(std::size_t bytes);

    string getSSLChiphers();

    void on_autologout();

    Pop3Session popSession;
    mutex_t mux_;
    buffer_ptr readq_;
    output_queue_t writeq_;
    bool tls_start_delayed = false;

    // Flag, required for correct do_shutdown() call.
    bool session_finished = false;
};

}

#endif // _YPOP_SERVER_SESSION_H_
