LIBRARY()
OWNER(g:xeno)

NO_UTIL()
NO_WERROR()

CFLAGS(
    -DBOOST_SPIRIT_THREADSAFE
)

PEERDIR(
    contrib/libs/msgpack
    contrib/restricted/boost/crc
    mail/ymod_blackbox
    mail/ymod_tvm
    mail/ymod_httpclient
    mail/ymod_ratecontroller
    mail/ymod_metricserver
    mail/ymod_statserver
    mail/yplatform/lib
    mail/yplatform/lib/convert
    mail/macs
    mail/macs_pg
    mail/mimeparser
    mail/user_journal
    mail/webmail-recognizer/lib
)

ADDINCL(
    mail/pop3/src
    mail/webmail-recognizer/lib
)

SRCS(
    backend/mbody/storage/mbody_stream_parser.cpp
    backend/mbody/storage/mulcagate_storage.cpp
    backend/mbody/storage/raw_storage.cpp
    backend/mbody/storage/storage.cpp
    backend/mbody/storage/string_storage.cpp
    backend/mbody/util/header_parser.cpp
    backend/mbody/util/meta_parser.cpp
    backend/mbody/util/recognizer_wrapper.cpp
    backend/mbody/util/utf16.cpp
    backend/mbody/util/utfizer.cpp
    backend/mbody/message_access.cpp
    backend/mbody/message_loader.cpp
    backend/backend_types.cpp
    common/helpers/helpers.cpp
    common/helpers/host_id.cpp
    common/log/log.cpp
    common/log/logger.cpp
    network/session.cc
    server/pop3_session.cc
    processor/pop_backend.cc
    processor/pop_backend_pg.cc
    processor/pop_context.cc
    processor/command.cpp
    processor/impl_info.cc
    processor/impl_login.cc
    processor/impl_trans.cc
    processor/transliterate.cc

    GLOBAL backend/mbody/storage/message_storage.cpp
    GLOBAL backend/impl.cc
    GLOBAL processor/processor_impl.cc
    GLOBAL server/server.cc
)

END()
