#!/bin/sh

#/usr/bin/fetch 'http://curl.haxx.se/ca/cacert.pem'
wget -qO- "http://curl.haxx.se/ca/cacert.pem" > /etc/postfix/certs/cacert.pem

openssl="/usr/bin/openssl"

hashdirectory="/etc/postfix/certs/hash"
tmpfile="tmpcert.pem"

cat cacert.pem | while read row; do
	if_start=$( echo $row | grep '\-\-\-\-\-BEGIN\ CERTIFICATE\-\-\-\-\-')
	if_end=$( echo $row | grep '\-\-\-\-\-END\ CERTIFICATE\-\-\-\-\-')
	
	[ "$if_start" = "" ] || echo -n > $tmpfile
	echo $row >> $tmpfile

	# Here we got the full certificate name it and push into hash directory
	[ "$if_end" = "" ] || {
		md5=$( ${openssl} x509 -noout -modulus -in ${tmpfile} | ${openssl} md5)
		/bin/mv $tmpfile "$hashdirectory/$md5.pem" 
#&& /etc/postfix/certs/c_rehash /etc/postfix/certs/hash/
		#/bin/mv $tmpfile "$hashdirectory"
	}
done
