#!/bin/bash

# Настройка postfix:

chmod 644 /etc/postfix/main.cf*
chmod 644 /etc/post

chmod 644 /etc/postfix/bounce_templates/*
chmod 644 /etc/postfix/transport_maps/*
chmod 644 /etc/postfix/header_checks/*

chmod 755 /etc/postfix/bounce_templates
chmod 755 /etc/postfix/transport_maps
chmod 755 /etc/postfix/header_checks

# Инициализация domain_maps:
if [ -f "/etc/yandex/domain_maps/configs/maps.conf.${QLOUD_COMPONENT}" ]; then
    ln -svf /etc/yandex/domain_maps/configs/maps.conf.${QLOUD_COMPONENT} /etc/yandex/domain_maps/maps.conf

    chmod 644 /etc/yandex/domain_maps/get-domain-maps.cron
    ln -svf /etc/yandex/domain_maps/get-domain-maps.cron /etc/cron.d/get-domain-maps

    /usr/sbin/get-domain-maps
fi

# Настройка virtual-alias-maps:
if [ -v VIRTUAL_ALIAS_MAPS ] && [ $VIRTUAL_ALIAS_MAPS -eq 1 ];then
    ln -svf /etc/yandex/sorm-aliases/get-sorm-aliases.cron /etc/cron.d/get-sorm-aliases
    chmod 644 /etc/yandex/sorm-aliases/get-sorm-aliases.cron
    /usr/sbin/get-sorm-aliases.sh
fi

[[ -z ${POSTFIX_PORT} ]] && POSTFIX_PORT=5252

ln -svf /etc/postfix/main.cf-$CONFIG_NAME    /etc/postfix/main.cf
ln -svf /etc/postfix/master.cf-$POSTFIX_PORT /etc/postfix/master.cf

maps=$(postconf -h | grep -w hash: | grep -vE "aliases|smtp_scache" | cut -d ':' -f2)
for i in $maps; do
    postmap $i 2>/dev/null
done

exec "$@"
