#!/bin/bash

. ./patches
. ./version

from_version="$postfix_version"
to_version="$1"

if [ -z "$1" ]; then
  cat <<EOF
Миграция патчей: ./migrate.sh <версия postfix>
EOF
  exit 0
fi

if [ "$from_version" == "$to_version" ]; then
  echo "Миграция из ${from_version} в ${to_version} - нечто странное."
fi

test -f postfix-${to_version}.tar.gz ||
  wget https://de.postfix.org/ftpmirror/official/postfix-${to_version}.tar.gz

test -d postfix-${to_version} && rm -rf postfix-${to_version}

tar -xzf postfix-${to_version}.tar.gz

# Optimistically apply old patches to new version

for p in $patches; do
  old_patch_name="postfix-${from_version}-${p}.patch"
  new_patch_name="postfix-${to_version}-${p}.patch"

  # reserve original files
  altered_files=$(grep '^--- ' $old_patch_name | awk '{print $2}' | sed 's|[^/]\+/||' | sort | uniq )
  for f in $altered_files; do
      f=${f%%.original}
      cp "postfix-${to_version}/$f" "postfix-${to_version}/$f.original"
  done

  # apply patch
  patch -d postfix-${to_version} -p1 < "$old_patch_name" > log 	1>&2

  # form new patch
  test -f "$new_patch_name" && rm "$new_patch_name"

  for f in $altered_files; do
    f=${f%%.original}
    diff -Naurw "postfix-${to_version}/$f.original" "postfix-${to_version}/$f" >> "$new_patch_name"
  done

  if grep -i 'failed' log; then
    echo "Automatic migration was FAILED!"
    echo "Unfortunately you should do it MANUALLY, sorry :("
    rm log
    rm -rf postfix-${to_version}
    exit 1
  fi

done

rm log
rm -rf postfix-${to_version}

echo "Done!"
