package ru.yandex.mail.promocode;

import java.util.List;

import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

/**
 * Simple, silly, stupid service for uploading and distribution of promo codes
 *
 * @author Sergey Galyamichev
 */
@Path("/promo")
@Consumes(MediaType.APPLICATION_JSON)
public interface PromoCodeService {
    /**
     * Upload list of promo codes for a specified by tag promo action
     *
     * @param tag        promo action id
     * @param promoCodes list of promo codes
     */
    @POST
    @Path("upload")
    void upload(@QueryParam("tag") String tag,
                List<String> promoCodes);

    /**
     * Assigns new promo code to the user or returns already assigned
     *
     * @param tag      promo action id
     * @param uid      user identifier
     * @param deviceId device identifier
     * @return promo code
     */
    @GET
    @Path("assign")
    String assign(@QueryParam("tag") String tag,
                  @QueryParam("uid") Long uid,
                  @Nullable @QueryParam("device_id") String deviceId);

    /**
     * Checks if promo code assigned to the user with given uid and deviceId
     *
     * @param uid       user identifier
     * @param deviceId  device identifier
     * @param promoCode promo code
     */
    @POST
    @Path("validate")
    void validate(@QueryParam("uid") Long uid,
                  @Nullable @QueryParam("device_id") String deviceId,
                  String promoCode);
}
