-- name: colliedb_minutes_since_ml_sync
SELECT
    (EXTRACT(EPOCH FROM (now() - sync_timestamp))::bigint / 60) AS colliedb_minutes_since_ml_sync
FROM service_sync
WHERE service_type = 'ml'::collie.service_type;


-- name: colliedb_minutes_since_staff_sync
SELECT
    (EXTRACT(EPOCH FROM (now() - sync_timestamp))::bigint / 60) AS colliedb_minutes_since_staff_sync
FROM service_sync
WHERE service_type = 'staff'::collie.service_type;


-- name: colliedb_total_processing_users
SELECT
    count(*) AS colliedb_total_processing_users
FROM directory_events
WHERE 0 < pending_events_count;


-- name: mopsdb_total_operations_chunks
SELECT
    count(*) AS mopsdb_total_operations_chunks
FROM operations.chunks;


-- name: mopsdb_alive_locks
SELECT
    count(*) AS mopsdb_alive_locks
FROM operations.user_locks
WHERE operations.expiration_date(heartbeated, ttl) >= now();


-- name: queuedb_active_tasks
SELECT
    service || '_' || task || '_' || state as queuedb,
    cnt
FROM (
    SELECT count(*) as cnt, service, task, state FROM queue.tasks
    GROUP BY service, task, state) tbl;    


-- name: queuedb_processed_tasks
SELECT
    service || '_' || task || '_' || state as queuedb,
    cnt
FROM (
    SELECT count(*) as cnt, service, task, state FROM queue.processed_tasks
    GROUP BY service, task, state) tbl;    
