from typing import Mapping, Union

from mail.python.theatre.app.settings.db import DbSettings
from mail.python.theatre.stages.db_stats.types import Db, DbHost


def db_settings_from_config(datasource_config: Mapping[str, str]) -> DbSettings:
    settings = DbSettings()
    settings.host = datasource_config['host']
    settings.port = datasource_config['port']
    settings.name = datasource_config['dbname']
    settings.user = datasource_config['user']
    return settings


def make_db_sources(config: Mapping[str, Union[str, Mapping]]) -> Mapping[str, Db]:
    return {
        name: Db(hosts=[DbHost(dsn=db_settings_from_config(datasource).pg_dsn())])
        for name, datasource in config['datasources'].items()
        if datasource['host']
    }
