from typing import Mapping, Union
from aiopg import Connection

from .base_task import BaseTask


class CachedbPurge(BaseTask):
    name = 'cachedb_purge'

    def __init__(self, config: Mapping[str, Union[str, Mapping]]):
        super(CachedbPurge, self).__init__(config)

    async def _run(self, connection: Connection) -> None:
        async with connection.cursor() as cursor:
            await cursor.execute(f"SELECT now() - interval '{self.vars()['interval']}'")
            date = (await cursor.fetchall())[0][0]

            for db_user in ['sendbernar', 'xeno']:
                while True:
                    await cursor.execute(f"SELECT * FROM impl.purge({self.vars()['count']}, '{db_user}', '{date}')")
                    ret = (await cursor.fetchall())[0][0]
                    if ret == 0:
                        break

            self.logger.info('Completed purging cachedb')
