from typing import Mapping, Union
from aiopg import Connection

from .base_task import BaseTask


class MopsDbPgPartmanMaintenance(BaseTask):
    name = 'mopsdb_pg_partman_maintenance'

    def __init__(self, config: Mapping[str, Union[str, Mapping]]):
        super(MopsDbPgPartmanMaintenance, self).__init__(config)

    async def _run(self, connection: Connection) -> None:
        async with connection.cursor() as cursor:
            async with cursor.begin():
                await cursor.execute('UPDATE part_config SET infinite_time_partitions=True')

            async with cursor.begin():
                await cursor.execute('SET lock_timeout to 0')
                await cursor.execute('SELECT run_maintenance(NULL, FALSE, FALSE)')
                self.logger.info('Completed maintenance')

                await cursor.execute('SELECT parent_table FROM part_config')
                tables = [
                    parent_table
                    async for parent_table, in cursor
                ]
                for table in tables:
                    await cursor.execute('ANALYZE {}'.format(table))
                    self.logger.info('Completed ANALYZE of {}'.format(table))
