from typing import Mapping, Union
from aiopg import Connection

from .base_task import BaseTask


class MopsDbRemoveOldLocks(BaseTask):
    name = 'mopsdb_remove_old_locks'

    def __init__(self, config: Mapping[str, Union[str, Mapping]]):
        super(MopsDbRemoveOldLocks, self).__init__(config)

    async def _run(self, connection: Connection) -> None:
        async with connection.cursor() as cursor:
            await cursor.execute('''
                SELECT util.release_old_locks()
            ''')
            self.logger.info('Completed removing old locks')
