from typing import Mapping, Union
from aiopg import Connection

from .base_task import BaseTask


class MopsDbRemoveOldTasks(BaseTask):
    name = 'mopsdb_remove_old_tasks'

    def __init__(self, config: Mapping[str, Union[str, Mapping]]):
        super(MopsDbRemoveOldTasks, self).__init__(config)

    async def _run(self, connection: Connection) -> None:
        async with connection.cursor() as cursor:
            await cursor.execute('''
                DELETE FROM operations.tasks AS t
                WHERE
                    (created < now() - '1 day'::interval)
                    OR NOT EXISTS (SELECT 1 FROM operations.chunks AS c WHERE t.task_id=c.task_id)
            ''')
            self.logger.info('Completed removing old and empty tasks')
