#!/bin/bash -e

if [[ "${ENVIRONMENT_TYPE}" ]]; then
    if [[ "${ENVIRONMENT_NAME}" ]]; then
        ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
    else
        ENVIRONMENT="${ENVIRONMENT_TYPE}"
    fi
else
    echo "[ERROR] ENVIRONMENT_TYPE not set, cannot start"
    exit 1
fi

case "$ENVIRONMENT" in
    production|intranet-production|intranet-prestable)
        PGPASS_SECRET_ID="sec-01dw7t34p8x6rw5dke0wymppvt"
        ;;
    prestable)
        PGPASS_SECRET_ID="sec-01f24t3vbqnbs7qzvcp8m40k4g"
        ;;
    testing)
        PGPASS_SECRET_ID="sec-01dvt5p21agmpz2fkx37e3yk77"
        ;;
    load)
        PGPASS_SECRET_ID="sec-01e1y28peky6tghj0e9bp097jn"
        ;;
    *)
        echo "[ERROR] Unknown environment: ${ENVIRONMENT}, cannot start"
        exit 1
        ;;
esac

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
PGPASS_TARGET_PATH=/etc/puli/.pgpass
for i in {1..10}; do
    echo "getting pgpass"
    yav get version ${PGPASS_SECRET_ID} -o pgpass > ${PGPASS_TARGET_PATH}

    if [[ -s ${PGPASS_TARGET_PATH} ]]; then
        echo "chown/chmod ${PGPASS_TARGET_PATH}"
        chown wmi:wmi ${PGPASS_TARGET_PATH} && chmod 600 ${PGPASS_TARGET_PATH}

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No ${PGPASS_TARGET_PATH} found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to install pgpass, cannot start"
    exit 1
fi

ln -sf /etc/puli/config-${ENVIRONMENT}.yml /etc/puli/config.yml
